#include <iostream>
#include <vector>
#include <algorithm>

struct pokusaj {
    unsigned milj;
    unsigned broj;
};

bool stepenDv(unsigned num) {
    return (num & (num - 1)) == 0;
}

void promeniBracket(std::vector<unsigned>& snage, const int milj, int izmene) {
    std::sort(snage.begin(), snage.end(), [milj](unsigned a, unsigned b) {
        return (a == milj) ? false : ((b == milj) ? true : a > b);
    });

    for (int i = 0; i < izmene; ++i) {
        std::swap(snage[i % (snage.size() - 1)], snage[(i + 1) % (snage.size() - 1)]);
    }
}
int simRunde(std::vector<unsigned> snage, const pokusaj& trenPokusaj) {
    int milj = snage[trenPokusaj.milj - 1];
    int izmene = trenPokusaj.broj;
    int runda = 0;
    int n = snage.size();

    promeniBracket(snage, milj, izmene);

    while (n > 0) {
        runda++;
        for (int i = 0; i < n; i += 2) {

            if (n == 1) return runda;

            int igrac1 = i;
            int igrac2 = i + 1;

            if (snage[igrac1] >= snage[igrac2]) {
                if (snage[igrac2] == milj) return runda;
                snage[i / 2] = snage[igrac1];
            }
            else {
                if (snage[igrac1] == milj) return runda;
                snage[i / 2] = snage[igrac2];
            }
        }
        n /= 2;
    }
}

int kadajecetiri(std::vector<unsigned> snage, const pokusaj& trenPokusaj) {
    int milj = snage[trenPokusaj.milj - 1];
    int izmene = trenPokusaj.broj;
    int runda = 0;
    int n = 4;

    
    while (n > 0) {
        runda++;
        for (int i = 0; i < n; i += 2) {

            if (n == 1) return runda;

            int igrac1 = i;
            int igrac2 = i + 1;

            if (milj == 4) return 3;
            else if (milj == 1) return 1;

            if (n == 4 && (snage[igrac1] == milj || snage[igrac2] == milj)) {
                int miljenik, protivnik;
                miljenik = snage[igrac1] == milj ? igrac1 : igrac2;
                protivnik = snage[igrac1] == milj ? igrac2 : igrac1;

                if (snage[miljenik] < snage[protivnik]) {
                    if (izmene >= 1) return 2;
                    else return 1;
                }
            }

            if (snage[igrac1] >= snage[igrac2]) {
                if (snage[igrac2] == milj) return runda;
                snage[i / 2] = snage[igrac1];
            }
            else {
                if (snage[igrac1] == milj) return runda;
                snage[i / 2] = snage[igrac2];
            }
        }
        n /= 2;
    }
}

int main() {

    unsigned n, brpokusaja;

    std::cin >> n;
    if (!stepenDv(n)) return 1;

    std::vector<unsigned> snage(n);

    for (auto& x : snage) std::cin >> x;

    std::cin >> brpokusaja;
    if (brpokusaja == 0) return 1;

    std::vector<pokusaj> pokusaji(brpokusaja);

    for (auto& x : pokusaji) {
        std::cin >> x.milj >> x.broj;
    }

    if (n != 4) {
        for (int i = 0; i < brpokusaja; i++) {
            int rundaMilj = simRunde(snage, pokusaji[i]);
            std::cout << rundaMilj << std::endl;
        }
    } else {
        for (int i = 0; i < brpokusaja; i++) {
            int rundaMilj = kadajecetiri(snage, pokusaji[i]);
            std::cout << rundaMilj << std::endl;
        }
    }

    return 0;
}